<?php

namespace App\Http\Controllers;

use App\Frontend;
use App\MatrixLevel;
use App\Http\Controllers\Controller;
use App\Plan;
use App\Epin;
use App\GeneralSettings;
use Auth;
use Illuminate\Http\Request;

class PlanController extends Controller
{
    function epin()
    {
        $page_title = "Unused Epin";
        $epin = Epin::whereStatus(1)->orderby('id', 'desc')->get();
        return view('admin.plan.epins', compact('page_title','epin'));
    }
      function usedepin()
    {
        $page_title = "Used Epin";
        $epin = Epin::whereStatus(2)->orderby('id', 'desc')->get();
        return view('admin.plan.epins', compact('page_title','epin'));
    }

      function adminpingenerate(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric|min:100', 
            'number' => 'required|numeric|min:1'
        ]);

         $user = Auth::guard('admin')->user();


          foreach(range(1,$request->number) as $i)
       {
         $pin = rand(1000, 9999) . '-' . rand(100, 999) . '-' . rand(1000, 9999) . '-' . rand(100, 999);
        Epin::create([
            'created_user_id' => 1,
            'user_id' => 1,
            'pin' => $pin,
            'amount' => $request->amount,
            'status' => 1,
        ]);

         }
         
        


        return back()->with('success', 'Pin generated successfuly');

    }




     function levels()
    {
        $page_title = "Manage Level";
        return view('admin.plan.level', compact('page_title'));
    }

     public function matrix(Request $request)
    {
        $this->validate($request,[
            'matrix_height' => 'required|numeric|min:1',
            'matrix_width' => 'required|numeric|min:1'
        ]);



        $gnl = GeneralSettings::first();
        $gnl->matrix_height = $request->matrix_height;
        $gnl->matrix_width = $request->matrix_width;
        $gnl->save();

        return back()->with('success', 'Matrix Height & Width Updated');

    }

    function plans()
    {
        $page_title = "Manage Plan";
        $plan = Plan::with('plan_level')->get();
        return view('admin.plan.index', compact('page_title', 'plan'));
    }

    function create()
    {
        $page_title = "Create Plan";
        return view('admin.plan.create', compact('page_title'));
    }

    function edit(Plan $plan)
    {
        $page_title = __($plan->name);
        return view('admin.plan.edit', compact('page_title', 'plan'));
    }

    function store(Request $request)
    {
        $this->validate($request, [
            'ref_bonus' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
            'name' => 'required|string|max:191',
            'discount' => 'required|string|max:191',
            'amount.*' => 'required|numeric|min:0',
        ]);
        $plan = Plan::create([
            'name' => $request->name,
            'price' => $request->price,
            'discount' => $request->discount,
            'ref_bonus' => $request->ref_bonus,
            'status' => 1,
        ]);
        //$this->insertIntoMatrix($request->amount, $plan->id);

         return back()->with('success', 'New MLM Plam Created Sucessfully');

    }

    function update(Request $request, Plan $plan)
    {
        $this->validate($request, [
            'ref_bonus' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
            'name' => 'required|string|max:191',
            'discount' => 'required|string|max:191',
            'amount.*' => 'required|numeric|min:0',
        ]);
         MatrixLevel::wherePlan_id(13)->delete();
        $plan = Plan::find($request->id);
        $plan->update([
            'name' => $request->name,
            'price' => $request->price,
            'ref_bonus' => $request->ref_bonus,
            'discount' => $request->discount,
            'status' => $request->status,
        ]);
        //$this->insertIntoMatrix($request->amount, $plan->id);
        return back()->with('success', 'MLM Plan Updated Sucessfully');
    }

    function insertIntoMatrix($amount, $id)
    {
        foreach ($amount as $key => $data) {
            MatrixLevel::create([
                'plan_id' => $id,
                'amount' => $data,
                'level' => $key + 1,
            ]);
        }
    }

}
